<?LassoScript

	Include('../ChartFX_Designer.lasso');
	
		// 
		// Chart
		//
		
		Var: 'myHeight'=240;
		Var: 'myWidth'=320;
		Var: 'myChart' = ChartFX_Designer(-Width=$myWidth, -Height=$myHeight, -Gallery='Lines');
		
		//
		// Data
		//
		
		Var: 'myData' = Array(Array( 'Labels', 'Calls', 'Sales'), Array('1/1/2007', 10, 20), Array('1/2/2007', 34, 43), Array('1/3/2007', 5, 94), Array('1/4/2007', 30, 34), Array('1/5/2007', 15, 51), Array('1/6/2007', 20, 40), Array('1/7/2007', 17, 63));
		$myChart->SetLassoData($myData);
	
		//
		// Template
		//
		
		$myChart->SetFont(-Name='Verdana', -Size=7);
		$myChart->Set3D;
	
	If(Action_Param('image') != '');
		
		//
		// Serve
		//
		// This code is called if the page is called in an HTML image tag with an action
		// parameter of image=true.
		//
	
		$myChart->Serve;
		
	Else;
		
		//
		// Description 
		//
		// This code is run if the file is called directly without any action
		// parameters.  It displays the chart, template, and data.
		//
		
		Var: 'myFile' = String_ReplaceRegExp(Response_FilePath, -Find='.*/', -Replace='');
		'<html>';
		'<head>';
		'<title>' + $myFile->Replace('_', ' ') & - '.lasso' + '</title>';
		'<style> p,td {font-size: 12px; color: #333333;}</style>';
		'</head>';
		'<body>';
		'<p><b>' + $myFile->Replace('_', ' ') & - '.lasso' + '</b></p>';
		'<p><img src="' + $myfile + '?image=true" width="320" height="240" border="0" /></p>';
		'<hr />';
		'<p><b>Template</b></p>';
		'<p style="white-space: pre;">' + encode_html($myChart) + '</p>';
		'<hr />';
		'<p><b>Data</b></p>';
		'<p><table cellspacing="3" cellpadding="3" border="0">';
		Iterate($myData, Var('myField'));
			'<tr><td>';
			$myField->Join('</td><td>');
			'</td></tr>';
		/Iterate;
		'</table></p>';
		'</body>';
		'</html>';
	/If;
?>